package app.firezone.synk.network.Fragments;

import android.annotation.SuppressLint;
import android.os.Bundle;

import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.LinearLayoutManager;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import android.widget.Toast;

import app.firezone.synk.network.API.APIClient;
import app.firezone.synk.network.API.MyApi;
import app.firezone.synk.network.API.SharedPrefManager;
import app.firezone.synk.network.Adapter.BgmiMatchAdapter;
import app.firezone.synk.network.R;
import app.firezone.synk.network.databinding.FragmentBgmiUpcomingBinding;
import app.firezone.synk.network.model.CheckJoinedResponse;
import app.firezone.synk.network.model.Joined_Match_Model;
import app.firezone.synk.network.model.MatchResponse;
import app.firezone.synk.network.model.Match_Model;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;


public class Bgmi_Upcoming_Fragment extends Fragment {

    ArrayList<Match_Model> mlist = new ArrayList<>();
    BgmiMatchAdapter myAdapter;
    FragmentBgmiUpcomingBinding binding;
    TextView tvNoData;

    String gamename;

    @SuppressLint("MissingInflatedId")
    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        binding = FragmentBgmiUpcomingBinding.inflate(inflater, container, false);
        View root = binding.getRoot();

        if (getArguments() != null) {
            gamename = getArguments().getString("gamename");
        }

        tvNoData = root.findViewById(R.id.tvNoData);
        setupRecyclerView();

        fetchMatchData();

        binding.swipeRefresh.setOnRefreshListener(() -> fetchMatchData());

        return root;
    }

    private void setupRecyclerView() {
        LinearLayoutManager layoutManager = new LinearLayoutManager(getContext());
        binding.bgmiMatchRecy.setLayoutManager(layoutManager);

        myAdapter = new BgmiMatchAdapter(getContext(), mlist);
        binding.bgmiMatchRecy.setAdapter(myAdapter);
    }


    private void fetchMatchData() {
        if (!binding.swipeRefresh.isRefreshing()) {
            binding.shimmerContainer.setVisibility(View.VISIBLE);
        }

        // ✨ Show shimmer
        binding.shimmerContainer.setVisibility(View.VISIBLE);
        binding.bgmiMatchRecy.setVisibility(View.GONE);
        tvNoData.setVisibility(View.GONE);

        mlist.clear();

        MyApi myApi = APIClient.getApiClient(getContext()).create(MyApi.class);
        Call<MatchResponse> call = myApi.getMatchDataByGameName(gamename);

        call.enqueue(new Callback<MatchResponse>() {
            @Override
            public void onResponse(Call<MatchResponse> call, Response<MatchResponse> response) {
                binding.swipeRefresh.setRefreshing(false);

                if (response.isSuccessful() && response.body() != null && response.body().isSuccess() && response.body().getMatches() != null) {
                    ArrayList<Match_Model> matches = new ArrayList<>(response.body().getMatches());
                    ArrayList<Match_Model> upcomingMatches = new ArrayList<>();

                    for (Match_Model match : matches) {
                        if ("Upcoming".equalsIgnoreCase(match.getMatchstatus())) {
                            upcomingMatches.add(match);
                        }
                    }

                    if (upcomingMatches.isEmpty()) {
                        showNoDataView();
                    } else {
                        enrichMatchesWithJoinData(upcomingMatches);
                    }

                } else {
                    showNoDataView();
                }
            }

            @Override
            public void onFailure(Call<MatchResponse> call, Throwable t) {
                binding.swipeRefresh.setRefreshing(false);
                Toast.makeText(getContext(), "Error: " + t.getMessage(), Toast.LENGTH_SHORT).show();
                showNoDataView();
            }
        });
    }

    private void enrichMatchesWithJoinData(ArrayList<Match_Model> matchList) {
        long userId = SharedPrefManager.getInstance(getContext()).getUserId();
        MyApi myApi = APIClient.getApiClient(getContext()).create(MyApi.class);

        ArrayList<Match_Model> enrichedList = new ArrayList<>();
        AtomicInteger completedCount = new AtomicInteger(0);
        int totalMatches = matchList.size();

        for (Match_Model originalMatch : matchList) {
            Match_Model match = new Match_Model();
            match.copyFrom(originalMatch);

            AtomicInteger perMatchCount = new AtomicInteger(0);
            match.setMatchCode("not_joined");
            match.setTotalPlayerJoined("0");

            myApi.checkIfUserJoined(userId, match.getId()).enqueue(new Callback<CheckJoinedResponse>() {
                @Override
                public void onResponse(Call<CheckJoinedResponse> call, Response<CheckJoinedResponse> response) {
                    if (response.isSuccessful() && response.body() != null && response.body().isSuccess()) {
                        match.setMatchCode("joined");
                    }

                    if (perMatchCount.incrementAndGet() == 2) {
                        enrichedList.add(match);
                        checkIfAllMatchesProcessed(enrichedList, completedCount, totalMatches);
                    }
                }

                @Override
                public void onFailure(Call<CheckJoinedResponse> call, Throwable t) {
                    if (perMatchCount.incrementAndGet() == 2) {
                        enrichedList.add(match);
                        checkIfAllMatchesProcessed(enrichedList, completedCount, totalMatches);
                    }
                }
            });

            myApi.fetchMatchJoinedUsers(match.getId()).enqueue(new Callback<ArrayList<Joined_Match_Model>>() {
                @Override
                public void onResponse(Call<ArrayList<Joined_Match_Model>> call, Response<ArrayList<Joined_Match_Model>> response) {
                    if (response.isSuccessful() && response.body() != null) {
                        match.setTotalPlayerJoined(String.valueOf(response.body().size()));
                    }

                    if (perMatchCount.incrementAndGet() == 2) {
                        enrichedList.add(match);
                        checkIfAllMatchesProcessed(enrichedList, completedCount, totalMatches);
                    }
                }

                @Override
                public void onFailure(Call<ArrayList<Joined_Match_Model>> call, Throwable t) {
                    if (perMatchCount.incrementAndGet() == 2) {
                        enrichedList.add(match);
                        checkIfAllMatchesProcessed(enrichedList, completedCount, totalMatches);
                    }
                }
            });
        }
    }

    private void checkIfAllMatchesProcessed(ArrayList<Match_Model> enrichedList, AtomicInteger completedCount, int totalMatches) {
        if (completedCount.incrementAndGet() == totalMatches) {
            mlist.clear();
            mlist.addAll(enrichedList);

            if (myAdapter != null) {
                myAdapter.notifyDataSetChanged();
            }

            if (mlist.isEmpty()) {
                showNoDataView();
            } else {
                // ✅ Hide shimmer, show data
                binding.shimmerContainer.setVisibility(View.GONE);
                binding.bgmiMatchRecy.setVisibility(View.VISIBLE);
                tvNoData.setVisibility(View.GONE);
            }
        }
    }

    private void showNoDataView() {
        binding.shimmerContainer.setVisibility(View.GONE);
        binding.bgmiMatchRecy.setVisibility(View.GONE);
        tvNoData.setVisibility(View.VISIBLE);
    }
}
